unit TChartNormal1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ImgList, Menus, Grids, ExtCtrls, StdCtrls,
  Buttons, ActnList, ToolWin, ComCtrls, 

  VEdit, NEdit,
  Plot, Plotdefs, PlotMenu, PlotImageList, Data, TeeProcs, TeEngine, Chart,
  Series;

type
  TMainForm = class(TForm)
    Panel1: TPanel;
    StringGrid1: TStringGrid;
    MinNEdit: TNEdit;
    Label1: TLabel;
    Label2: TLabel;
    MaxNEdit: TNEdit;
    Label3: TLabel;
    StepSizeNEdit: TNEdit;
    Label4: TLabel;
    MeanNEdit: TNEdit;
    Label5: TLabel;
    StdDevNEdit: TNEdit;
    GoBitBtn: TBitBtn;
    GoCrazyBitBtn: TBitBtn;
    CrazyTimer: TTimer;
    ClearAllBitBtn: TBitBtn;
    NoisyBitBtn: TBitBtn;
    TraceBitBtn: TBitBtn;
    TypeBitBtn: TBitBtn;
    Chart1: TChart;
    StatusBar1: TStatusBar;
    Series1: TLineSeries;
    procedure ClearAllBitBtnClick(Sender: TObject);
    procedure GoBitBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure PlotMenu1ExitMenuItemClick(Sender: TObject);
    procedure NoisyBitBtnClick(Sender: TObject);
    procedure GoCrazyBitBtnClick(Sender: TObject);
    procedure CrazyTimerTimer(Sender: TObject);
    procedure Plot1FileOpen(Sender: TObject; TheFile: String);
    procedure TraceBitBtnClick(Sender: TObject);
    procedure TypeBitBtnClick(Sender: TObject);
  private
    //Chart1: TPlot;
    //PlotMenu1: TPlotMenu;
    Revolutions,
    StartWidth,
    StartHeight: Integer;
    Angle,
    AngleInc: Single;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

const
  RADIUS = 50.0;

procedure TMainForm.FormCreate(Sender: TObject);
{var
  PlotImageList : TPlotImageList;}
begin
  //Chart1 := TPlot.Create(Self);
  Chart1.Parent := MainForm;
  Chart1.Align := alClient;
  {Chart1.PlotType := ptXY;
  Chart1.NoSeries := 2;
  Chart1.MakeDummyData(20);}
  //PlotMenu1.Plot := Chart1;
  StringGrid1.Cells[0, 0] := 'Test:';
  StringGrid1.Cells[0, 1] := 'Score:';
  StringGrid1.ColWidths[0] := 60;
  //PlotImageList := TPlotImageList.Create(Self);
  //PlotImageList.Free;
  //GoBitBtnClick(Sender);
  //PlotActionList1.Plot := Chart1;
end;

procedure TMainForm.ClearAllBitBtnClick(Sender: TObject);
var
  i: Integer;
begin
  for i := 0 to Chart1.SeriesList.Count-1 do
  begin
    Chart1.Series[i].Clear;
  end;

  for i := 1 to StringGrid1.ColCount-1 do
  begin
    StringGrid1.Cells[i, 0] := '';
    StringGrid1.Cells[i, 1] := '';
  end;
end;

procedure TMainForm.GoBitBtnClick(Sender: TObject);
var
  X, Y: Single;
  Mean: Single;
  StdDev: Single;
  Min: Single;
  Max: Single;
  StepSize: Single;
  TheSeries: Integer;
  TheScore: Single;
  i: Integer;
  FStartTime:          Int64; {TLargeInteger;}
  FFinishTime:         Int64;
  FFrequency:          Int64;
  ElapsedTime: Double;
begin
  Screen.Cursor := crHourGlass;
  QueryPerformanceFrequency(FFrequency); {counts per second}
{get the starting time:}
  QueryPerformanceCounter(FStartTime); { LARGE_INTEGER}

  for i := 0 to Chart1.SeriesList.Count-1 do
  begin
    Chart1.Series[i].Clear;
  end;

  Mean := MeanNEdit.AsReal;
  StdDev := StdDevNEdit.AsReal;
  Min := MinNEdit.AsReal;
  Max := MaxNEdit.AsReal;
  StepSize := StepSizeNEdit.AsReal;

{Set the axes:}
  Chart1.BottomAxis.Maximum := Max;
  Chart1.BottomAxis.Minimum := Min;
  Chart1.LeftAxis.Minimum := 0;
  //Chart1.LeftAxis.Intercept := 0;

  X := Min;
  while (X <= Max) do
  begin
    Y := Exp(-Sqr((X-Mean)/(2*StdDev))) /
      Sqrt(2*Pi*StdDev);
{Don't fire any events, and don't adjust axes:}
    Chart1.SeriesList[0].AddXY(X, Y);
    X := X + StepSize;
  end;

  {Chart1.YAxis.Min := Chart1.Series[0].YMin;}
  //Chart1.LeftAxis.Maximum := Chart1.Series[0].YMax;

  {for i := 1 to StringGrid1.ColCount-1 do
  begin
    if (Length(StringGrid1.Cells[i, 0]) > 0) then
    begin
      if (Length(StringGrid1.Cells[i, 1]) > 0) then
      begin
        try
          TheScore := StrToFloat(StringGrid1.Cells[i, 1]);
          TheSeries := Chart1.Add(-1);
          Chart1[TheSeries].Name := StringGrid1.Cells[i, 0];
          Chart1[TheSeries].AddPoint(TheScore, Chart1.YAxis.Min, TRUE, TRUE);
          Chart1[TheSeries].AddPoint(TheScore, Chart1.YAxis.Max, TRUE, TRUE);
          Chart1[TheSeries].Visible := TRUE;
          Chart1[TheSeries].Symbol := TSymbol(i mod (1+Ord(sDownTriangle)));
        finally
        end;
      end;
    end;
  end;}
{get the finishing time:}
  QueryPerformanceCounter(FFinishTime); { LARGE_INTEGER}
{take difference and convert to ms:}
  ElapsedTime := 1000 * (FFinishTime - FStartTime) / FFrequency;
  StatusBar1.SimpleText := Format('Drawing %d points takes %g ms',
    [Chart1.Series[0].Count, ElapsedTime]);
  Screen.Cursor := crDefault;
end;

procedure TMainForm.PlotMenu1ExitMenuItemClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.NoisyBitBtnClick(Sender: TObject);
begin
  //Chart1.MakeDummyData(100);
end;

procedure TMainForm.GoCrazyBitBtnClick(Sender: TObject);
begin
  if (CrazyTimer.Enabled) then
  begin
    CrazyTimer.Enabled := FALSE;
    GoCrazyBitBtn.Caption := 'Go Crazy';
    TraceBitBtn.Enabled := TRUE;
  end
  else
  begin
    Revolutions := 0;
    StartWidth := Width;
    StartHeight := Height;
    Angle := 0;
    AngleInc := 4 * Pi / 180;
    GoCrazyBitBtn.Caption := 'Enough !';
    CrazyTimer.Enabled := TRUE;
    TraceBitBtn.Enabled := FALSE;
  end;
end;

procedure TMainForm.CrazyTimerTimer(Sender: TObject);
begin
  Width := StartWidth + Round(RADIUS * Sin(Angle));
  Height := StartHeight + Round(RADIUS * Cos(Angle));
  Angle := Angle + AngleInc;
  Inc(Revolutions);
  StatusBar1.SimpleText := IntToStr(Revolutions);
end;

procedure TMainForm.Plot1FileOpen(Sender: TObject; TheFile: String);
var
  TheTitle: String;
begin
  TheTitle := ExtractFileName(Application.ExeName);
  TheTitle := Copy(TheTitle, 1, Length(TheTitle)-4);
  TheTitle := TheTitle + ' - ' + ExtractFileName(TheFile);
  Application.Title := TheTitle;
  MainForm.Caption := TheTitle;
end;

procedure TMainForm.TraceBitBtnClick(Sender: TObject);
begin
  //Chart1.Trace;
end;

procedure TMainForm.TypeBitBtnClick(Sender: TObject);
var
 ThePlotType: Integer;
begin
  {ThePlotType := Ord(Chart1.PlotType);
  ThePlotType := (ThePlotType+1) mod (Ord(High(TPlotType))+1);
  Chart1.SeriesList.ClearSeries;
  Chart1.PlotType := TPlotType(ThePlotType);
  case Chart1.PlotType of
    ptXY: Chart1.MakeDummyData(100);
    ptError, ptMultiple: Chart1.MakeDummyData(20);
    ptColumn, ptStack, ptNormStack: Chart1.MakeDummyData(10);
    ptPie: Chart1.MakeDummyData(10);
    ptPolar:
      begin
        Chart1.XAxis.Min := -10;
        Chart1.XAxis.Max := 10;
        Chart1.YAxis.Min := -10;
        Chart1.YAxis.Max := 10;
        Chart1.MakeDummyData(20);
      end;
    pt3DWire, pt3DSurface:
      begin
        Chart1.XAxis.Min := 0;
        Chart1.XAxis.Max := 10;
        Chart1.YAxis.Min := 0;
        Chart1.YAxis.Max := 10;
        Chart1.MakeDummyData(20);
        Chart1.NoSeries := 8;
        Chart1.MakeDummyData(10);
      end;
  else ;
  end;}
end;

end.
